%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Triad model vector field 
% Created by John Harlim 
% Last edited: March 16, 2018  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function f = triad(x)

global gamma a omega beta

A = [0 omega 0; -2*omega -gamma -beta; 0 beta -gamma];

f = A*x;
f(2,:) = f(2,:) + a*x(1,:).*x(3,:);
f(3,:) = f(3,:) - a*x(1,:).*x(2,:);